/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.border.AbstractBorder;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.CompoundBorder;
import com.sun.java.swing.plaf.UIResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;

public class MotifBorderFactory
implements Serializable {
    private static Border loweredBevelBorder;
    private static Border raisedBevelBorder;
    private static Border buttonBorder;
    private static Border toggleButtonBorder;
    private static Border focusBorder;
    private static Border fieldBorder;
    private static Border menuBarBorder;

    public static Border getLoweredBevelBorder() {
        if (loweredBevelBorder == null) {
            loweredBevelBorder = new BevelBorder(false);
        }
        return loweredBevelBorder;
    }

    public static Border getRaisedBevelBorder() {
        if (raisedBevelBorder == null) {
            raisedBevelBorder = new BevelBorder(true);
        }
        return raisedBevelBorder;
    }

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getFocusBorder() {
        if (focusBorder == null) {
            focusBorder = new FocusBorder();
        }
        return focusBorder;
    }

    public static Border getFieldBorder() {
        if (fieldBorder == null) {
            fieldBorder = new FieldBorder();
        }
        return fieldBorder;
    }

    public static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            toggleButtonBorder = new ToggleButtonBorder();
        }
        return toggleButtonBorder;
    }

    public static Border getMenuBarBorder() {
        if (menuBarBorder == null) {
            menuBarBorder = new MenuBarBorder();
        }
        return menuBarBorder;
    }

    public static void drawBezel(Graphics graphics, int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        UIManager.getColor((Object)"controlDisabled");
        Color color = UIManager.getColor((Object)"activeCaptionBorder");
        Color color2 = UIManager.getColor((Object)"controlShadow");
        Color color3 = UIManager.getColor((Object)"controlDkShadow");
        UIManager.getColor((Object)"controlLtHighlight");
        Color color4 = UIManager.getColor((Object)"controlHighlight");
        Color color5 = graphics.getColor();
        graphics.translate(n, n2);
        if (bl) {
            if (bl2) {
                graphics.setColor(color);
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
            }
            graphics.setColor(color2);
            graphics.drawRect(1, 1, n3 - 3, n4 - 3);
            graphics.setColor(color4);
            graphics.drawLine(2, n4 - 3, n3 - 3, n4 - 3);
            graphics.drawLine(n3 - 3, 2, n3 - 3, n4 - 4);
        } else {
            if (bl2) {
                graphics.setColor(color);
                graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                graphics.setColor(color4);
                graphics.drawLine(1, 1, 1, n4 - 3);
                graphics.drawLine(2, 1, n3 - 4, 1);
                graphics.setColor(color2);
                graphics.drawLine(2, n4 - 3, n3 - 3, n4 - 3);
                graphics.drawLine(n3 - 3, 1, n3 - 3, n4 - 4);
                graphics.setColor(color3);
                graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
                graphics.drawLine(n3 - 2, n4 - 2, n3 - 2, 1);
            } else {
                graphics.setColor(color4);
                graphics.drawLine(1, 1, 1, n4 - 3);
                graphics.drawLine(2, 1, n3 - 4, 1);
                graphics.setColor(color2);
                graphics.drawLine(2, n4 - 3, n3 - 3, n4 - 3);
                graphics.drawLine(n3 - 3, 1, n3 - 3, n4 - 4);
                graphics.setColor(color3);
                graphics.drawLine(1, n4 - 2, n3 - 2, n4 - 2);
                graphics.drawLine(n3 - 2, n4 - 2, n3 - 2, 0);
            }
            graphics.translate(-n, -n2);
        }
        graphics.setColor(color5);
    }

    private static class BevelBorder
    extends AbstractBorder
    implements UIResource,
    Serializable {
        private Color darkShadow = UIManager.getColor((Object)"controlShadow");
        private Color lightShadow = UIManager.getColor((Object)"controlLtHighlight");
        private boolean isRaised;

        public BevelBorder(boolean bl) {
            this.isRaised = bl;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(this.isRaised ? this.lightShadow : this.darkShadow);
            graphics.drawLine(n, n2, n + n3 - 1, n2);
            graphics.drawLine(n, n2 + n4 - 1, n, n2 + 1);
            graphics.setColor(this.isRaised ? this.darkShadow : this.lightShadow);
            graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.drawLine(n + n3 - 1, n2 + n4 - 1, n + n3 - 1, n2 + 1);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public boolean isOpaque(Component component) {
            return true;
        }
    }

    private static class FocusBorder
    extends AbstractBorder
    implements UIResource,
    Serializable {
        private Color controlFocus;
        private Color control;
        static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (((JComponent)component).hasFocus()) {
                if (this.controlFocus == null) {
                    this.controlFocus = UIManager.getColor((Object)"activeCaptionBorder");
                }
                graphics.setColor(this.controlFocus);
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                return;
            }
            if (this.control == null) {
                this.control = UIManager.getColor((Object)"control");
            }
            graphics.setColor(this.control);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }
    }

    private static class MarginBorder
    extends AbstractBorder
    implements UIResource,
    Serializable {
        private Insets i;

        MarginBorder(Insets insets) {
            this.i = insets;
        }

        public Insets getBorderInsets(Component component) {
            return this.i;
        }
    }

    private static class FieldBorder
    extends CompoundBorder
    implements UIResource,
    Serializable {
        public FieldBorder() {
            super(MotifBorderFactory.getFocusBorder(), (Border)new CompoundBorder(MotifBorderFactory.getLoweredBevelBorder(), (Border)new MarginBorder(new Insets(3, 3, 3, 3))));
        }
    }

    static class ButtonBorder
    extends AbstractBorder
    implements UIResource,
    Serializable {
        static final Insets insets = new Insets(7, 7, 8, 8);
        private Color disabled = UIManager.getColor((Object)"controlDisabled");
        private Color controlFocus = UIManager.getColor((Object)"activeCaptionBorder");
        private Color controlShadow = UIManager.getColor((Object)"controlShadow");
        private Color lightShadow = UIManager.getColor((Object)"controlLtHighlight");
        private Color controlHighlight = UIManager.getColor((Object)"controlHighlight");
        private Color ltHighlight = UIManager.getColor((Object)"controlLtHightlight");

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                ButtonModel buttonModel = abstractButton.getModel();
                bl = buttonModel.isArmed() && buttonModel.isPressed();
                boolean bl4 = bl2 = buttonModel.isArmed() && bl || abstractButton.isFocusPainted() && abstractButton.hasFocus();
                if (abstractButton instanceof JButton) {
                    bl3 = ((JButton)abstractButton).isDefaultButton();
                }
            }
            if (bl3) {
                if (bl2) {
                    graphics.setColor(this.controlFocus);
                    graphics.drawRect(n, n2, n3 - 1, n4 - 1);
                    bl2 = false;
                }
                graphics.setColor(this.controlShadow);
                graphics.drawRect(n + 3, n + 3, n3 - 7, n4 - 7);
                graphics.setColor(this.controlHighlight);
                graphics.drawLine(n + 4, n2 + n4 - 4, n + n3 - 4, n2 + n4 - 4);
                graphics.drawLine(n + n3 - 4, n2 + 3, n + n3 - 4, n2 + n4 - 4);
            }
            MotifBorderFactory.drawBezel(graphics, n + 6, n2 + 6, n3 - 11, n4 - 11, bl, bl2);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        ButtonBorder() {
        }
    }

    private static class ToggleButtonBorder
    extends AbstractBorder
    implements UIResource,
    Serializable {
        static final Insets insets = new Insets(2, 2, 3, 3);

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (component instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)component;
                ButtonModel buttonModel = abstractButton.getModel();
                if (buttonModel.isArmed() && buttonModel.isPressed() || buttonModel.isSelected()) {
                    MotifBorderFactory.drawBezel(graphics, n, n2, n3, n4, buttonModel.isPressed() || buttonModel.isSelected(), abstractButton.hasFocus());
                    return;
                }
                MotifBorderFactory.drawBezel(graphics, n, n2, n3, n4, false, abstractButton.isFocusPainted() && abstractButton.hasFocus());
                return;
            }
            MotifBorderFactory.drawBezel(graphics, n, n2, n3, n4, false, false);
        }

        public Insets getBorderInsets(Component component) {
            return insets;
        }

        ToggleButtonBorder() {
        }
    }

    private static class MenuBarBorder
    extends AbstractBorder
    implements UIResource,
    Serializable {
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JMenuBar jMenuBar = (JMenuBar)component;
            if (jMenuBar.isBorderPainted()) {
                Dimension dimension = jMenuBar.getSize();
                MotifBorderFactory.drawBezel(graphics, n, n2, dimension.width, dimension.height, false, false);
            }
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(6, 6, 6, 6);
        }

        MenuBarBorder() {
        }
    }
}

